                                         /***********************************************************************************************\
* Freescale MMA845xQ Driver
*
* Filename: mma845x.c
*
* Description: Driver source file for Freescale MMA851Q, MMA8452Q and MMA8453Q accelerometers
*
* (c) Copyright 2011, Freescale, Inc.  All rights reserved.
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
\***********************************************************************************************/

#include "system.h"

/***********************************************************************************************\
* Private macros
\***********************************************************************************************/

/***********************************************************************************************\
* Private type definitions
\***********************************************************************************************/

/***********************************************************************************************\
* Private prototypes
\***********************************************************************************************/

/***********************************************************************************************\
* Private memory declarations
\***********************************************************************************************/

/***********************************************************************************************\
* Public memory declarations
\***********************************************************************************************/

#pragma DATA_SEG __SHORT_SEG _DATA_ZEROPAGE

extern byte SlaveAddressIIC;

#pragma DATA_SEG DEFAULT

/***********************************************************************************************\
* Public functions
\***********************************************************************************************/

/*********************************************************\
* Put MMA845xQ into Active Mode
\*********************************************************/
void FXOS8700CQ_Active (void)
{
  /*
  ** Set the Active bit in System Control 1 Register.
  */
  IIC_RegWrite(SlaveAddressIIC, CTRL_REG1, (IIC_RegRead(SlaveAddressIIC, CTRL_REG1) | ACTIVE_MASK));
}


/*********************************************************\
* Put MMA845xQ into Standby Mode
\*********************************************************/
byte FXOS8700CQ_Standby (void)
{
  byte n;
  /*
  **  Read current value of System Control 1 Register.
  **  Put sensor into Standby Mode by clearing the Active bit.
  **  Return with previous value of System Control 1 Register.
  */
  n = IIC_RegRead(SlaveAddressIIC, CTRL_REG1);
  IIC_RegWrite(SlaveAddressIIC, CTRL_REG1, n & (~ACTIVE_MASK));
  return (n & ACTIVE_MASK);
}


/*********************************************************\
* Initialize FXOS8700CQ
\*********************************************************/
void  FXOS8700CQ_Init (void)
{
  byte n;
  byte o;
  
  /*
  **  Reset sensor, and wait for reboot to complete
  */
  
  IIC_RegWrite(SlaveAddressIIC, CTRL_REG2, RST_MASK);
  
  // (TO Sep 2012), per d/s wait at least 1ms after issuing
  // a reset before attempting communications.

  /*
  **  Brute force delay for about 5ms
  */
  for (n=0x10; n!=0; n--)
  {
    for (o=0xFF; o!=0; o--) {}
  }

  do {
    n = IIC_RegRead(SlaveAddressIIC, CTRL_REG2);
  } while (n & RST_MASK);
  
  /*
  **  Configure sensor for:
  **    - Hybrid Mode (TO, Aug 2012)
  **    - Enable Hyb Mode Auto Increments (TO, Aug 2012)
  **    - Max Mag OSR
  **    - Sleep Mode Poll Rate of 50Hz (20ms)
  **    - System Output Data Rate of 200Hz (5ms)
  **    - Full Scale of +/-2g
  */                     
  // OSR=max, hybrid mode (TO, Aug 2012)
  IIC_RegWrite(SlaveAddressIIC, M_CTRL_REG1, (HYBRID_ACTIVE|M_OSR2_MASK|M_OSR1_MASK|M_OSR0_MASK) );
  // enable hybrid autoinc
  IIC_RegWrite(SlaveAddressIIC, M_CTRL_REG2, M_HYB_AUTOINC_MASK);  
  // Enable interrupts for DRDY (TO, Aug 2012)
  IIC_RegWrite(SlaveAddressIIC, CTRL_REG4, INT_EN_DRDY_MASK );
  // Set FSR of accel to +/-2g
  IIC_RegWrite(SlaveAddressIIC, XYZ_DATA_CFG_REG, FULL_SCALE_2G);
  // Set ODRs
  IIC_RegWrite(SlaveAddressIIC, CTRL_REG1, (HYB_ASLP_RATE_25HZ|HYB_DATA_RATE_50HZ)  ); 
  
  /*Sensys Config*/
  /*  IIC_RegWrite(SlaveAddressIIC, 0x2A, 0x08);
    IIC_RegWrite(SlaveAddressIIC, 0x2B, 0x80);
    IIC_RegWrite(SlaveAddressIIC, 0x09, 0x00);
    IIC_RegWrite(SlaveAddressIIC, 0x0E, 0x00);*/
    
}


/***********************************************************************************************\
* Private functions
\***********************************************************************************************/
